/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.BaseNode;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.ServiceException;

class NodeLEAP
extends BaseNode {
    private Object terminationLock = new Object();
    private boolean terminating = false;

    public NodeLEAP(String name, boolean hasPM) {
        super(name, hasPM);
    }

    public Object accept(HorizontalCommand cmd) throws IMTPException {
        try {
            if (this.terminating) {
                throw new IMTPException("Dead node");
            }
            return this.serveHorizontalCommand(cmd);
        }
        catch (ServiceException se) {
            throw new IMTPException("Service Error", se);
        }
    }

    public boolean ping(boolean hang) throws IMTPException {
        if (hang) {
            this.waitTermination();
        }
        return this.terminating;
    }

    public void exit() throws IMTPException {
        this.terminating = true;
        this.notifyTermination();
    }

    public void interrupt() throws IMTPException {
        this.notifyTermination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTermination() {
        Object object = this.terminationLock;
        synchronized (object) {
            try {
                this.terminationLock.wait();
            }
            catch (InterruptedException ie) {
                System.out.println("PING wait interrupted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTermination() {
        Object object = this.terminationLock;
        synchronized (object) {
            this.terminationLock.notifyAll();
        }
    }
}

